<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TechShiksha - Free Computer Education</title>
    <style>
        :root {
            --black: #000000;
            --white: #ffffff;
            --accent-pink: #ff00aa;
            --accent-green: #00ff9d;
            --accent-blue: #00a8ff;
            --accent-orange: #ff7b00;
            --border-radius: 16px;
            --box-shadow: 0 12px 24px rgba(0,0,0,0.2);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }

        body {
            background-color: var(--black);
            color: var(--white);
            overflow-x: hidden;
            line-height: 1.6;
        }

        /* Cosmic Background */
        .cosmic-bg {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
            background: radial-gradient(ellipse at center, 
                        rgba(0,168,255,0.1) 0%, 
                        rgba(0,0,0,1) 70%);
            animation: cosmicPulse 20s infinite alternate;
        }

        @keyframes cosmicPulse {
            0% { opacity: 0.3; }
            100% { opacity: 0.7; }
        }

        /* Navigation */
        .navbar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 2rem 5%;
            position: fixed;
            width: 100%;
            top: 0;
            z-index: 1000;
            background-color: rgba(0,0,0,0.8);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }

        .logo {
            font-size: 2rem;
            font-weight: 800;
            background: linear-gradient(90deg, var(--accent-pink), var(--accent-green));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            text-decoration: none;
        }

        .nav-links {
            display: flex;
            gap: 2.5rem;
        }

        .nav-links a {
            color: var(--white);
            text-decoration: none;
            font-weight: 500;
            position: relative;
            padding: 0.5rem 0;
            transition: all 0.3s ease;
        }

        .nav-links a:hover {
            color: var(--accent-blue);
        }

        .nav-links a::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 0;
            height: 2px;
            background: var(--accent-green);
            transition: width 0.3s ease;
        }

        .nav-links a:hover::after {
            width: 100%;
        }

        /* Hero Section */
        .hero {
            min-height: 100vh;
            display: flex;
            align-items: center;
            padding: 10rem 5% 5rem;
            position: relative;
        }

        .hero-content {
            max-width: 1200px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 4rem;
            align-items: center;
        }

        .hero-text h1 {
            font-size: 4rem;
            margin-bottom: 2rem;
            line-height: 1.2;
            background: linear-gradient(90deg, var(--white), var(--accent-blue));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .hero-text p {
            font-size: 1.3rem;
            margin-bottom: 3rem;
            color: rgba(255,255,255,0.8);
        }

        .donate-btn {
            display: inline-block;
            padding: 1.2rem 2.5rem;
            border-radius: 50px;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s ease;
            font-size: 1.1rem;
            margin-right: 1rem;
            border: none;
            cursor: pointer;
            background: linear-gradient(45deg, var(--accent-pink), var(--accent-blue));
            color: var(--black);
            box-shadow: 0 8px 25px rgba(255,0,170,0.4);
        }

        .donate-btn:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(255,0,170,0.6);
        }

        .hero-image {
            position: relative;
            z-index: 1;
            animation: floatUpDown 6s infinite ease-in-out;
        }

        @keyframes floatUpDown {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-20px); }
        }

        .hero-image img {
            width: 100%;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            border: 5px solid rgba(255,255,255,0.1);
        }

        /* Mission Section */
        .mission {
            padding: 8rem 5%;
            background-color: rgba(0,0,0,0.7);
        }

        .section-title {
            text-align: center;
            margin-bottom: 5rem;
        }

        .section-title h2 {
            font-size: 3rem;
            margin-bottom: 1.5rem;
            background: linear-gradient(90deg, var(--accent-green), var(--accent-orange));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .mission-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 3rem;
            max-width: 1200px;
            margin: 0 auto;
        }

        .mission-card {
            background: rgba(255,255,255,0.05);
            border-radius: var(--border-radius);
            padding: 3rem 2rem;
            box-shadow: var(--box-shadow);
            transition: all 0.4s ease;
            border: 1px solid rgba(255,255,255,0.1);
            backdrop-filter: blur(5px);
            perspective: 1000px;
        }

        .mission-card:hover {
            transform: translateY(-15px) rotateX(10deg);
            background: rgba(255,255,255,0.1);
        }

        /* Team Section */
        .team {
            padding: 8rem 5%;
            background: linear-gradient(135deg, 
                        rgba(0,168,255,0.1), 
                        rgba(0,255,157,0.1));
        }

        .team-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 3rem;
            max-width: 1200px;
            margin: 0 auto;
        }

        .team-member {
            position: relative;
            perspective: 1000px;
            height: 400px;
        }

        .member-card {
            width: 100%;
            height: 100%;
            transform-style: preserve-3d;
            transition: 0.6s;
            position: relative;
        }

        .team-member:hover .member-card {
            transform: rotateY(180deg);
        }

        .member-front,
        .member-back {
            position: absolute;
            width: 100%;
            height: 100%;
            backface-visibility: hidden;
            border-radius: 20px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 2rem;
        }

        .member-front {
            background: rgba(0,0,0,0.5);
            transform: rotateY(0deg);
            border: 2px solid var(--accent-pink);
        }

        .member-back {
            background: linear-gradient(45deg, var(--accent-pink), var(--accent-blue));
            transform: rotateY(180deg);
            color: white;
        }

        /* Contact Section */
        .contact {
            padding: 8rem 5%;
            background-color: rgba(0,0,0,0.7);
        }

        .contact-form {
            max-width: 600px;
            margin: 0 auto;
            background: rgba(255,255,255,0.05);
            padding: 3rem;
            border-radius: 20px;
            border: 1px solid var(--accent-green);
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        input, textarea {
            width: 100%;
            padding: 1rem;
            background: rgba(255,255,255,0.1);
            border: 1px solid rgba(255,255,255,0.2);
            border-radius: 10px;
            color: white;
            transition: 0.4s;
        }

        input:focus, textarea:focus {
            border-color: var(--accent-blue);
            outline: none;
        }

        /* Footer */
        .footer {
            padding: 5rem 5% 2rem;
            background-color: rgba(0,0,0,0.9);
            border-top: 1px solid rgba(255,255,255,0.1);
        }

        .social-links {
            display: flex;
            gap: 1rem;
            justify-content: center;
            margin: 2rem 0;
        }

        .social-link {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: rgba(255,255,255,0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--white);
            transition: 0.4s;
        }

        .social-link:hover {
            background: var(--accent-pink);
            transform: translateY(-5px);
        }

        /* Responsive Design */
        @media (max-width: 1024px) {
            .hero-content {
                grid-template-columns: 1fr;
                text-align: center;
            }
            
            .hero-image {
                max-width: 600px;
                margin: 0 auto;
            }
        }

        @media (max-width: 768px) {
            .nav-links {
                display: none;
            }
            
            .hero-text h1 {
                font-size: 2.5rem;
            }
        }
    </style>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <!-- Cosmic Background -->
    <div class="cosmic-bg"></div>

    <!-- Navigation -->
    <nav class="navbar">
        <a href="#" class="logo">TechShiksha</a>
        <div class="nav-links">
            <a href="#home">Home</a>
            <a href="#mission">Mission</a>
            <a href="#team">Team</a>
            <a href="#contact">Contact</a>
            <a href="donation.php" class="donate-btn">Donate Now</a>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero" id="home">
        <div class="hero-content">
            <div class="hero-text">
                <h1>Free Computer Education for All</h1>
                <p>Empowering underprivileged youth with cutting-edge tech skills since 2025</p>
                <a href="donation.php" class="donate-btn">Support Our Mission</a>
            </div>
            <div class="hero-image">
                <img src="https://images.unsplash.com/photo-1550751827-4bd374c3f58b?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1000&q=80" alt="Coding Classroom">
            </div>
        </div>
    </section>

    <!-- Mission Section -->
    <section class="mission" id="mission">
        <div class="section-title">
            <h2>Our Mission</h2>
            <p>Transforming lives through technology education</p>
        </div>
        
        <div class="mission-cards">
            <div class="mission-card">
                <h3>🎯 2026 Goal</h3>
                <p>Train 10,000+ students in programming, web development, and digital literacy</p>
            </div>
            <div class="mission-card">
                <h3>💡 Free Education</h3>
                <p>Providing completely free courses with industry-recognized certifications</p>
            </div>
            <div class="mission-card">
                <h3>🌟 Success Stories</h3>
                <p>Over 1,500 graduates employed in tech companies</p>
            </div>
        </div>
    </section>

    <!-- Team Section -->
    <section class="team" id="team">
        <div class="section-title">
            <h2>Our Team</h2>
            <p>Dedicated professionals driving the mission</p>
        </div>
        
        <div class="team-grid">
            <div class="team-member">
                <div class="member-card">
                    <div class="member-front">
                        <img src="IMG_20240525_114747_316.jpg" alt="Team Member" style="width: 120px; height: 120px; border-radius: 50%; margin-bottom: 1rem;">
                        <h3>Rahul panda</h3>
                        <p>Founder & CEO</p>
                    </div>
                    <div class="member-back">
                        <p>2+ years in Tech Education</p>
                        <div class="social-links">
                            <a href="https://www.instagram.com/rahulpanda.52206/" class="social-link"><i class="fab fa-instagram"></i></a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Add more team members -->
        </div>
    </section>

    <!-- Contact Section -->
    <section class="contact" id="contact">
        <div class="section-title">
            <h2>Contact Us</h2>
            <p>Get in touch to support or join our mission</p>
        </div>
        
        <form class="contact-form">
            <div class="form-group">
                <input type="text" placeholder="Your Name" required>
            </div>
            <div class="form-group">
                <input type="email" placeholder="Your Email" required>
            </div>
            <div class="form-group">
                <textarea rows="5" placeholder="Your Message" required></textarea>
            </div>
            <button class="donate-btn">Send Message</button>
        </form>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="social-links">
            <a href="https://www.facebook.com/rahulpanda225" class="social-link"><i class="fab fa-facebook"></i></a>
            <a href="https://x.com/RAHULPANDA93007" class="social-link"><i class="fab fa-twitter"></i></a>
            <a href="https://www.instagram.com/rahulpanda.52206" class="social-link"><i class="fab fa-instagram"></i></a>
            <a href="https://www.youtube.com/@RPMONEY249" class="social-link"><i class="fab fa-youtube"></i></a>
        </div>
        <p style="text-align: center; color: rgba(255,255,255,0.7); margin-top: 2rem;">
            © 2025 TechShiksha. All rights reserved.
        </p>
    </footer>

    <script>
        // Smooth scrolling
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function(e) {
                e.preventDefault();
                document.querySelector(this.getAttribute('href')).scrollIntoView({
                    behavior: 'smooth'
                });
            });
        });

        // Scroll animation
        const animateOnScroll = () => {
            const elements = document.querySelectorAll('.mission-card, .team-member, .contact-form');
            
            elements.forEach(element => {
                const elementPosition = element.getBoundingClientRect().top;
                const screenPosition = window.innerHeight / 1.3;
                
                if (elementPosition < screenPosition) {
                    element.style.opacity = '1';
                    element.style.transform = 'translateY(0)';
                }
            });
        };

        window.addEventListener('load', animateOnScroll);
        window.addEventListener('scroll', animateOnScroll);

        // Mobile menu
        const menuBtn = document.createElement('div');
        menuBtn.innerHTML = '<i class="fas fa-bars"></i>';
        menuBtn.style.position = 'fixed';
        menuBtn.style.top = '2rem';
        menuBtn.style.right = '2rem';
        menuBtn.style.color = 'white';
        menuBtn.style.fontSize = '2rem';
        menuBtn.style.cursor = 'pointer';
        menuBtn.style.zIndex = '1000';
        menuBtn.style.display = 'none';
        document.body.appendChild(menuBtn);

        menuBtn.addEventListener('click', () => {
            const nav = document.querySelector('.nav-links');
            nav.style.display = nav.style.display === 'flex' ? 'none' : 'flex';
        });

        window.addEventListener('resize', () => {
            if (window.innerWidth > 768) {
                document.querySelector('.nav-links').style.display = 'flex';
                menuBtn.style.display = 'none';
            } else {
                document.querySelector('.nav-links').style.display = 'none';
                menuBtn.style.display = 'block';
            }
        });
    </script>
</body>
</html>