<?php
include('header.php');

// Ensure only ADMIN can access this page
if ($_SESSION['userid'] != "ADMIN") {
    echo "<script>window.location.href = 'index.php';</script>";
    die;
}

// Fetch all users
$res = mysqli_query($conn, "SELECT * FROM `usertable`");

// Delete user logic
if (isset($_POST['delete']) && $_POST['delete'] == "ahkwebsolutions") {
    if (isset($_POST['phone']) && !empty($_POST['phone'])) {
        $phone = mysqli_real_escape_string($conn, base64_decode($_POST['phone']));
        
        if ($phone && is_numeric($phone)) {
            $del = mysqli_query($conn, "DELETE FROM `usertable` WHERE phone='$phone'");
            if ($del) {
                echo "<script>
                    Swal.fire('Success', 'User Deleted Successfully!', 'success');
                    setTimeout(() => { window.location.href = 'userlist.php'; }, 1500);
                </script>";
            } else {
                echo "<script>Swal.fire('Error', 'Unable to delete user!', 'error');</script>";
            }
        } else {
            echo "<script>Swal.fire('Error', 'Invalid phone number!', 'error');</script>";
        }
    } else {
        echo "<script>Swal.fire('Error', 'Phone number is missing!', 'error');</script>";
    }
}

// Login functionality using phone
if (isset($_GET['login']) && $_GET['login'] == 1 && isset($_GET['phone']) && $_GET['phone'] != NULL) {
    $phone = base64_decode($_GET['phone']);
    $_SESSION['userid'] = $phone; 
    echo "<script>setTimeout(() => { window.location.href = ''; }, 0);</script>";
}
?>

<!-- HTML Content -->
<div class="container-fluid">
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1 class="m-0">User List</h1>
        </div>
    </div>
</div>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <table id="table_id" class="table table-striped table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center">S/No</th>
                                    <th class="text-center">Mobile No</th>
                                    <th>Name</th>
                                    <th class="text-center">Email ID</th>
                                    <th class="text-center">Wallet</th>
                                    <th class="text-center">Distributor Number</th>
                                    <th class="text-center">Premium user</th>
                                    <th class="text-center">Login Key</th>
                                    <th class="text-center">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                if (mysqli_num_rows($res) > 0) {
                                    $slno = 1;
                                    while ($data = mysqli_fetch_array($res)) {
                                        if ($data['phone'] == "7250915396") {
                                            continue;
                                        }
                                ?>
                                        <tr>
                                            <td class="text-center"><?php echo $slno; ?></td>
                                            <td class="text-center"><?php echo $data['phone']; ?></td>
                                            <td><?php echo $data['name']; ?></td>
                                            <td class="text-center"><?php echo $data['emailid']; ?></td>
                                            <td class="text-center">
                                                <a href="edituser.php?phone=<?php echo base64_encode($data['phone']); ?>" class="btn btn-success">
                                                    ₹ <?php echo $data['walletamount']; ?>
                                                </a>
                                            </td>
                                            <td class="text-center">
                                                <?php echo $data['createdby'] ? $data['createdby'] : 'N/A'; ?>
                                            </td>
                                            <td class="text-center">
                                                <?php echo $data['premium'] ? $data['premium'] : 'N/A'; ?>
                                            </td>
                                            <td class="text-center">
                                                <a href="userlist.php?phone=<?php echo base64_encode($data['phone']); ?>&login=1">
                                                    <img height="41px" src="assets/images/login-rounded-right.png">
                                                </a>
                                            </td>
                                            <td class="text-right">
                                                <a href="edituser.php?phone=<?php echo base64_encode($data['phone']); ?>" class="btn btn-success ml-2"><i class="fa fa-edit"></i></a>
                                                <form action="" method="post" class="d-inline">
                                                    <input type="hidden" name="phone" value="<?php echo base64_encode($data['phone']); ?>">
                                                    <input type="hidden" name="delete" value="ahkwebsolutions">
                                                    <button type="button" class="btn btn-danger ml-2" onclick="deleteRecord(this)"><i class="fa fa-trash"></i></button>
                                                </form>
                                            </td>
                                        </tr>
                                <?php
                                        $slno++;
                                    }
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
    $(document).ready(function() {
        $('#table_id').DataTable({
            dom: 'Bfrtip',
            responsive: true,
            pageLength: 500,
            buttons: ['copy', 'csv', 'excel', 'pdf', 'print']
        });
    });

    function deleteRecord(th) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $(th).parent().submit();
            }
        });
    }
</script>
