<?php
include('header.php');

// Ensure session is active for a distributor
if ($_SESSION['usertype'] != "DISTRIBUTOR") {
    ?>
    <script>
        window.location.href='index.php';
    </script>
    <?php
    die;
}

// Flag to check if retailer details are fetched
$is_fetched = false;

// Fetch retailer details
if (isset($_POST['fetch_retailer']) && $_POST['fetch_retailer'] == 'true') {
    $retailer_mobile = mysqli_real_escape_string($conn, $_POST['mobile']);

    // Fetch retailer details
    $retailer_query = mysqli_query($conn, "SELECT * FROM usertable WHERE phone='$retailer_mobile'");
    if (mysqli_num_rows($retailer_query) == 1) {
        $retailer = mysqli_fetch_assoc($retailer_query);
        $is_fetched = true; // Set flag to true
    } else {
        ?>
        <script>
            Swal.fire('Retailer Not Found', 'Invalid mobile number. Please try again.', 'error');
        </script>
        <?php
    }
}

// Perform balance transfer
if (isset($_POST['transfer_balance']) && $_POST['transfer_balance'] == 'true') {
    $distributor_id = $_SESSION['userid']; // Distributor logged-in ID
    $retailer_mobile = mysqli_real_escape_string($conn, $_POST['retailer_mobile']);
    $amount = mysqli_real_escape_string($conn, $_POST['amount']);

    // Validate amount
    if ($amount <= 0) {
        ?>
        <script>
            Swal.fire('Invalid Amount', 'Please enter a valid amount.', 'error');
        </script>
        <?php
        die;
    }

    // Fetch distributor and retailer details
    $distributor_query = mysqli_query($conn, "SELECT * FROM usertable WHERE userid='$distributor_id'");
    $retailer_query = mysqli_query($conn, "SELECT * FROM usertable WHERE phone='$retailer_mobile'");

    if (mysqli_num_rows($distributor_query) == 1 && mysqli_num_rows($retailer_query) == 1) {
        $distributor = mysqli_fetch_assoc($distributor_query);
        $retailer = mysqli_fetch_assoc($retailer_query);

        // Check sufficient balance in distributor's wallet
        if ($distributor['walletamount'] >= $amount) {
            // Determine commission based on transfer amount
            $commission = 0;
            if ($amount > 99) {
                $commission = 10; // Commission of 10 rupees for amounts over 100
            }

            // Start transaction
            mysqli_begin_transaction($conn);

            // Debit distributor's wallet
            $debit_query = mysqli_query($conn, "UPDATE usertable SET walletamount=walletamount-'$amount' WHERE userid='$distributor_id'");

            // Credit retailer's wallet
            $credit_query = mysqli_query($conn, "UPDATE usertable SET walletamount=walletamount+'$amount' WHERE phone='$retailer_mobile'");

            // Credit commission to distributor if applicable
            if ($commission > 0) {
                $commission_query = mysqli_query($conn, "UPDATE usertable SET walletamount=walletamount+'$commission' WHERE userid='$distributor_id'");
            }

            if ($debit_query && $credit_query) {
                // Commit transaction
                mysqli_commit($conn);
                ?>
                <script>
                    Swal.fire('Success', 'Balance transferred successfully.', 'success');
                    setTimeout(() => {
                        window.location.href = 'transferm.php';
                    }, 1000);
                </script>
                <?php
            } else {
                // Rollback transaction
                mysqli_rollback($conn);
                ?>
                <script>
                    Swal.fire('Error', 'Transaction failed. Please try again.', 'error');
                </script>
                <?php
            }
        } else {
            ?>
            <script>
                Swal.fire('Insufficient Balance', 'You do not have enough balance to complete this transaction.', 'error');
            </script>
            <?php
        }
    } else {
        ?>
        <script>
            Swal.fire('User Not Found', 'Invalid retailer mobile number.', 'error');
        </script>
        <?php
    }
}
?>
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <?php if ($is_fetched): ?>
                <!-- Show Retailer Details and Amount Box -->
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Retailer Details</h4>
                    </div>
                    <div class="card-body">
                        <form action="" method="POST">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Retailer Name:</label>
                                        <input type="text" class="form-control" value="<?php echo $retailer['name']; ?>" readonly>
                                    </div>
                                    <div class="form-group">
                                        <label>Retailer Mobile:</label>
                                        <input type="text" class="form-control" value="<?php echo $retailer['phone']; ?>" readonly>
                                    </div>
                                    <div class="form-group">
                                        <label>Retailer Email:</label>
                                        <input type="text" class="form-control" value="<?php echo $retailer['emailid']; ?>" readonly>
                                    </div>
                                    <div class="form-group">
                                        <label>Available Balance:</label>
                                        <input type="text" class="form-control" value="<?php echo $retailer['walletamount']; ?>" readonly>
                                    </div>
                                    <input type="hidden" name="retailer_mobile" value="<?php echo $retailer['phone']; ?>">
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Transfer Amount:</label>
                                        <input type="number" class="form-control" name="amount" placeholder="Enter Amount" min="100" required>
                                    </div>
                                    <input type="hidden" name="transfer_balance" value="true">
                                    <button type="submit" class="btn btn-primary">Transfer</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            <?php else: ?>
                <!-- Show Retailer Mobile Input Box -->
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Balance Transfer - Fetch Retailer Details</h4>
                    </div>
                    <div class="card-body">
                        <form action="" method="POST">
                            <div class="form-group">
                                <label>Retailer Mobile Number:</label>
                                <input type="number" class="form-control" maxlength="10" name="mobile" placeholder="Enter Retailer Mobile No" required>
                            </div>
                            <input type="hidden" name="fetch_retailer" value="true">
                            <button type="submit" class="btn btn-success">Fetch Details</button>
                        </form>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
