<?php
include('header.php');

// Check if user is logged in
if(!isset($_SESSION['userid'])) {
    header('Location: index.php');
    die();
}

// Get user details
$user_id = $_SESSION['userid'];
$user_query = mysqli_query($conn, "SELECT * FROM usertable WHERE userid='$user_id'");
$user_data = mysqli_fetch_assoc($user_query);

// Check if UPI ID is set, if not show form to add
if(empty($user_data['upi_id']) && !isset($_POST['save_upi'])) {
    ?>
    <div class="container-fluid">
        <div class="row page-header">
            <div class="col-lg-6 align-self-center">
                <h2>Setup UPI ID for Payments</h2>
            </div>
        </div>

        <section class="main-content">
            <div class="row">
                <div class="col-md-6 offset-md-3">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Enter Your UPI ID</h4>
                        </div>
                        <div class="card-body">
                            <form action="" method="POST">
                                <div class="form-group">
                                    <label>Your UPI ID (e.g. mobile@upi):</label>
                                    <input type="text" name="upi_id" class="form-control" required 
                                           placeholder="example@upi" pattern="[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$">
                                    <small class="text-muted">Ye wahi UPI ID hogi jisme aapko payment milega</small>
                                </div>
                                <button type="submit" name="save_upi" class="btn btn-primary">Save UPI ID</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <?php
    include('footer.php');
    die();
}

// Save UPI ID if submitted
if(isset($_POST['save_upi'])) {
    $upi_id = mysqli_real_escape_string($conn, $_POST['upi_id']);
    
    // Validate UPI ID format
    if(preg_match("/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/", $upi_id)) {
        mysqli_query($conn, "UPDATE usertable SET upi_id='$upi_id' WHERE userid='$user_id'");
        $user_data['upi_id'] = $upi_id;
        
        echo "<script>
            $(function(){
                Swal.fire(
                    'UPI ID Saved Successfully', 
                    'Ab aap QR code generate kar sakte hain',
                    'success'
                )
            })
        </script>";
    } else {
        echo "<script>
            $(function(){
                Swal.fire(
                    'Invalid UPI ID', 
                    'Please enter valid UPI ID (e.g. mobile@upi)',
                    'error'
                )
            })
        </script>";
    }
}

// Generate UPI payment string
$payment_data = "upi://pay?pa=".urlencode($user_data['upi_id'])."&pn=".urlencode($user_data['name'])."&am=&cu=INR&tn=Payment";

// Generate QR code URL
$qr_code_url = "http://api.qrserver.com/v1/create-qr-code/?data=".urlencode($payment_data)."&size=200x200";
?>

<div class="container-fluid">
    <div class="row page-header">
        <div class="col-lg-6 align-self-center">
            <h2>Your Personal UPI Payment QR Code</h2>
        </div>
    </div>

    <section class="main-content">
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Scan to Pay via UPI</h4>
                    </div>
                    <div class="card-body text-center">
                        <img src="<?php echo $qr_code_url; ?>" alt="UPI Payment QR Code" class="img-fluid">
                        <div class="mt-3">
                            <p><strong>UPI ID:</strong> <?php echo $user_data['upi_id']; ?></p>
                            <p><strong>Name:</strong> <?php echo $user_data['name']; ?></p>
                            <button onclick="copyToClipboard('<?php echo $user_data['upi_id']; ?>')" class="btn btn-sm btn-outline-primary">
                                Copy UPI ID
                            </button>
                        </div>
                        <p class="mt-3">Share this QR code to receive UPI payments directly</p>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Payment Instructions</h4>
                    </div>
                    <div class="card-body">
                        <ol>
                            <li>Share your QR code with anyone who wants to pay you</li>
                            <li>They can scan with any UPI app (Google Pay, PhonePe, PayTM, etc.)</li>
                            <li>Payment will come directly to your UPI ID: <?php echo $user_data['upi_id']; ?></li>
                            <li>For manual entry, share your UPI ID</li>
                        </ol>
                        
                        <div class="alert alert-info">
                            <strong>Note:</strong> UPI payments are instant and directly go to your linked bank account
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        Swal.fire({
            icon: 'success',
            title: 'Copied!',
            text: 'UPI ID copied to clipboard',
            timer: 2000
        });
    }, function(err) {
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Failed to copy UPI ID'
        });
    });
}
</script>

<?php include('footer.php'); ?>