<?php
session_start();
require_once "./utils/config.php";
require_once "./utils/common.php";
require_once "./dbcon.php";

if (!isset($_SESSION['user_id']) || !isset($_POST['amount'])) {
    header("Location: error.php?message=invalid_request");
    exit;
}

$user_id = $_SESSION['user_id'];
$amount = (float)$_POST['amount'];

// Validate amount
if ($amount <= 0) {
    header("Location: error.php?message=invalid_amount");
    exit;
}

// Generate transaction ID
$transactionId = "BAL-" . uniqid() . "-" . time();

try {
    // Store transaction record
    $stmt = $con->prepare("
        INSERT INTO balance_transactions 
        (user_id, transaction_id, amount, type, status) 
        VALUES (?, ?, ?, 'credit', 'INITIATED')
    ");
    
    $stmt->bind_param("ssd", $user_id, $transactionId, $amount);
    $stmt->execute();

    // Store payment data in session
    $_SESSION['payment_data'] = [
        'name' => $_SESSION['user_name'] ?? 'User',
        'email' => $_SESSION['email'] ?? '',
        'contact' => $_SESSION['contact'] ?? '',
        'amount' => $amount,
        'transaction_id' => $transactionId,
        'merchant_id' => API_STATUS === "LIVE" ? MERCHANTIDLIVE : MERCHANTIDUAT,
        'timestamp' => time(),
        'is_wallet_reload' => true
    ];

    // Redirect to payment gateway
    header("Location: payment_gateway.php");
    exit;

} catch (Exception $e) {
    error_log("Balance addition error: " . $e->getMessage());
    header("Location: error.php?message=transaction_failed");
    exit;
} 