<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PG Gateway</title>
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.14/dist/sweetalert2.all.min.js"></script>
</head>
<body>

<?php
session_start();
include('config.php');

define('MINIMUM_AMOUNT', 30);  // Set your minimum amount threshold here

if (isset($_SESSION['order_id'])) {
    $order_id = $_SESSION['order_id'];
    $customer_mobile = $_SESSION['customer_mobile'];

    if (!isset($_SESSION['wallet_updated'][$order_id])) {
        $url = "https://pay.aasif.tech/api/check-order-status";

        $postData = array(
            "user_token" => "b0d252b6b0d4039bad90f6a1e0eb992c",
            "order_id" => $order_id
        );

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));

        $response = curl_exec($ch);
        if (curl_errno($ch)) {
            echo "<script>alert('cURL Error: " . curl_error($ch) . "');</script>";
            exit;
        }
        curl_close($ch);

        $responseData = json_decode($response, true);

        if ($responseData["status"] == "1") {
            $txnStatus = $responseData["result"]["txnStatus"];
            $orderId = $responseData["result"]["orderId"];
            $status = $responseData["result"]["status"];
            $amount = $responseData["result"]["amount"];
            $date = $responseData["result"]["date"];
            $utr = $responseData["result"]["utr"];

            echo "Payment Successfully Received";
            echo "<br>AMOUNT ::: ".$amount;
            echo "<br>Mininum Amount ::: ".MINIMUM_AMOUNT;
           // echo "<br> IS equal ::: ".$amount >= MINIMUM_AMOUNT;
            
            
            if ($amount >= MINIMUM_AMOUNT) {
                // Update wallet if the amount meets the minimum threshold
                $sql = "UPDATE usertable SET walletamount = walletamount + $amount WHERE phone = '$customer_mobile'";

                if ($conn->query($sql) === TRUE) {
                    echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
<script>
    Swal.fire({
        title: 'SUCCESS',
        text: 'Wallet Updated Successfully',
        icon: 'success',
        confirmButtonText: 'OK'
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = 'https://razorhosts.in/admin/wallet.php';
        }
    });
</script>";

                    $_SESSION['wallet_updated'][$order_id] = true;
                } else {
                    echo "<script>
                        Swal.fire({
                            title: 'Wallet Update Failed',
                            text: 'Update failed: " . $conn->error . "',
                            icon: 'error',
                            confirmButtonText: 'OK'
                        }).then(function() {
                            window.location.href = '../admin/wallet';
                        });
                    </script>";
                }
            } elseif ($amount < MINIMUM_AMOUNT) {
                // Notify user of insufficient payment
                echo "<script>
                    Swal.fire({
                        title: 'Payment Insufficient',
                        text: 'The payment amount was less than the required minimum. Wallet not updated and payment not be refund.',
                        icon: 'warning',
                        confirmButtonText: 'OK'
                    }).then(function() {
                        window.location.href = 'https://razorhosts.in/admin/wallet.php';
                    });
                </script>";
            }
        } else {
            echo "<script>
                Swal.fire({
                    title: 'PAYMMENT GATEWAY API PROBLEM CONTACT TO YOUR DISTRIBUTOR',
                    text: 'API call unsuccessful. Status: " . ($responseData["status"] ?? "Unknown") . "',
                    icon: 'error',
                    confirmButtonText: 'OK'
                }).then(function() {
                    window.location.href = '../admin/wallet.php';
                });
            </script>";
        }
    } else {
        echo "<script>
            Swal.fire({
                title: 'Duplicate Order Attempt',
                text: 'Wallet already updated for this order ID',
                icon: 'info',
                confirmButtonText: 'OK'
            }).then(function() {
                window.location.href = 'https://razorhosts.in/';
            });
        </script>";
    }
} else {
    echo "<script>Swal.fire('Error', 'Order ID not set in session', 'error');</script>";
}
?>

</body>
</html>
