<?php
header("Content-type: application/javascript");

?>
function formatIFSC(input) {
    input.value = input.value.toUpperCase().replace(/\s+/g, '');
}

function fetchBankDetails() {
    let ifscCode = document.getElementById('ifsc').value.trim().toUpperCase();
    if (!ifscCode) {
        Swal.fire({ icon: 'error', title: 'Oops...', text: 'Please enter an IFSC code!' });
        return;
    }

    fetch(`https://ifsc.razorpay.com/${ifscCode}`)
        .then(response => {
            if (!response.ok) throw new Error('Invalid IFSC Code!');
            return response.json();
        })
        .then(data => {
            Swal.fire({
                icon: 'success',
                title: `Bank Details for IFSC: <b>${ifscCode}</b>`,
                html: `
                    <div style="text-align: center; font-size: 18px; line-height: 1.8;">
                        <p><strong>Bank Name:</strong> ${data.BANK}</p>
                        <p><strong>Branch:</strong> ${data.BRANCH}</p>
                        <p><strong>Address:</strong> ${data.ADDRESS}</p>
                        <p><strong>State:</strong> ${data.STATE}</p>
                        <p><strong>Contact:</strong> ${data.CONTACT || 'N/A'}</p>
                    </div>
                `,
                confirmButtonText: 'Close'
            });
        })
        .catch(error => {
            Swal.fire({ icon: 'error', title: 'Error', text: 'Invalid IFSC Code!' });
        });
}
