<?php
include('header.php');

// Admin check
if($_SESSION['userid'] != "ADMIN"){
    header('Location: index.php');
    die();
}

// Get all QR transactions
$transactions = mysqli_query($conn, "SELECT q.*, u.name, u.phone FROM qrtxn q JOIN usertable u ON q.username=u.username ORDER BY q.created_at DESC");
?>

<div class="container-fluid">
    <div class="row page-header">
        <div class="col-lg-6 align-self-center">
            <h2>QR Code Transactions</h2>
        </div>
    </div>

    <section class="main-content">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">All QR Payments</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>Txn ID</th>
                                        <th>Receiver</th>
                                        <th>Mobile</th>
                                        <th>Amount</th>
                                        <th>Status</th>
                                        <th>Date</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while($txn = mysqli_fetch_assoc($transactions)): ?>
                                    <tr>
                                        <td><?php echo $txn['txnid']; ?></td>
                                        <td><?php echo $txn['name']; ?></td>
                                        <td><?php echo $txn['phone']; ?></td>
                                        <td>₹<?php echo $txn['amount']; ?></td>
                                        <td>
                                            <span class="badge badge-<?php 
                                                echo $txn['status'] == 'completed' ? 'success' : 
                                                     ($txn['status'] == 'pending' ? 'warning' : 'danger'); 
                                            ?>">
                                                <?php echo ucfirst($txn['status']); ?>
                                            </span>
                                        </td>
                                        <td><?php echo date('d/m/Y H:i', strtotime($txn['created_at'])); ?></td>
                                        <td>
                                            <?php if($txn['status'] == 'pending'): ?>
                                                <a href="?approve=1&apid=<?php echo base64_encode($txn['txnid']); ?>" class="btn btn-sm btn-success">Approve</a>
                                                <a href="?reject=1&rejid=<?php echo base64_encode($txn['txnid']); ?>" class="btn btn-sm btn-danger">Reject</a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<?php include('footer.php'); ?>